﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Text;

namespace Inet.Viewer.Data
{
    /// <summary>
    /// Wrapper class for the state of a Graphics.
    /// Saves the state of the Graphics
    /// </summary>
    public class GraphicsState
    {
        private Brush brush;
        private Pen pen;

        /// <summary>
        /// The used brush
        /// </summary>
        public Brush Brush
        {
            set
            {
                brush = value;
            }
            get
            {
                return brush;
            }
        }

        /// <summary>
        /// The used pen
        /// </summary>
        public Pen Pen
        {
            set
            {
                pen = value;
            }
            get
            {
                return pen;
            }
        }

        private Matrix transform;
        private Matrix internalTransform;
        private Region clip;
        private SmoothingMode smoothingMode;
        private PixelOffsetMode pixelOffsetMode;
        private TextRenderingHint textRenderingHint;
        private InterpolationMode interpolationMode;
        private CompositingMode compositingMode;

        /// <summary>
        /// This methods saves all the information that describe the state from the Graphics g
        /// and writes it to this GraphicState
        /// </summary>
        /// <param name="g">The graphics object to be store</param>
        /// <param name="painter">the painter to get objects that are not part of the graphics like the Brush and Pen</param>
        /// <param name="transform">the current transformation matrix</param>
        internal void SaveDataFromGraphics(Graphics g, Graphics2DPainter painter, Matrix transform)
        {
            // Graphics
            this.transform = g.Transform;
            this.clip = g.Clip;
            this.smoothingMode = g.SmoothingMode;
            this.pixelOffsetMode = g.PixelOffsetMode;
            this.textRenderingHint = g.TextRenderingHint;
            this.interpolationMode = g.InterpolationMode;
            this.compositingMode = g.CompositingMode;
            this.internalTransform = transform.Clone();

            // Graphics2DPainter                
            // Only for Pen, not for Brush, as the brush is stored in the Graphics2DPainter
            this.Pen = (Pen)painter.Pen.Clone();
        }

        /// <summary>
        /// This methods restores all the information that describe the state from the Graphics g
        /// and restores it to this GraphicState
        /// </summary>
        /// <param name="g">The graphics object to be store</param>
        /// <param name="painter">the painter to get objects that are not part of the graphics like the Brush and Pen</param>
        internal void RestoreDataToGrapics(Graphics g, Graphics2DPainter painter)
        {
            // Graphics 
            g.Transform = this.transform;
            g.Clip = this.clip;
            g.SmoothingMode = this.smoothingMode;
            g.PixelOffsetMode = this.pixelOffsetMode;
            g.TextRenderingHint = this.textRenderingHint;
            g.InterpolationMode = this.interpolationMode;
            g.CompositingMode = this.compositingMode;
            painter.SetTransform(internalTransform.Clone());

            // Graphics2DPainter
            // Only for Pen, not for Brush, as the brush is stored in the Graphics2DPainter            
            painter.Pen = (Pen)this.Pen.Clone();
        }
    }
}

